/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm;

import ibm.nways.jdm.AxisCanvas;
import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.JdmLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.ResourceBundle;

public class JdmLayoutDialog
extends Dialog
implements ActionListener {
    private GridBagLayout gbl;
    private CheckboxGroup schemeGroup;
    private Checkbox wideBoxScheme;
    private Checkbox tallBoxScheme;
    private Button applyButton;
    private Button cancelButton;
    private BrowserApplet browser;
    private JdmLayout jdmLayout;
    private Container widePanel;
    private Container tallPanel;
    private static String ApplyCommand = "Apply";
    private static String CancelCommand = "Cancel";
    private ResourceBundle myResources = ResourceBundle.getBundle("ibm.nways.jdm.JdmLayoutDialogResources", Locale.getDefault());

    public JdmLayoutDialog(BrowserApplet browserApplet) {
        super(browserApplet.getFrame(), false);
        this.widePanel = new SampleLayout(0);
        this.tallPanel = new SampleLayout(1);
        this.setTitle(this.myResources.getString("title"));
        this.browser = browserApplet;
        this.jdmLayout = (JdmLayout)browserApplet.getLayout();
        ((Component)this).setSize(400, 300);
        int n = this.jdmLayout.getScheme();
        this.gbl = new GridBagLayout();
        this.setLayout(this.gbl);
        this.schemeGroup = new CheckboxGroup();
        this.wideBoxScheme = new Checkbox(this.myResources.getString("wideSchemeLabel"), this.schemeGroup, n == 0);
        GridBagConstraints gridBagConstraints = this.makeConstraints(0, 0, 2, 1);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.anchor = 17;
        this.gbl.setConstraints(this.wideBoxScheme, gridBagConstraints);
        this.add(this.wideBoxScheme);
        gridBagConstraints = this.makeConstraints(2, 0, 2, 1);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.anchor = 10;
        this.gbl.setConstraints(this.widePanel, gridBagConstraints);
        this.add(this.widePanel);
        this.tallBoxScheme = new Checkbox(this.myResources.getString("tallSchemeLabel"), this.schemeGroup, n == 1);
        gridBagConstraints = this.makeConstraints(0, 1, 4, 1);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.gbl.setConstraints(this.tallBoxScheme, gridBagConstraints);
        this.add(this.tallBoxScheme);
        gridBagConstraints = this.makeConstraints(2, 1, 2, 1);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.gbl.setConstraints(this.tallPanel, gridBagConstraints);
        this.add(this.tallPanel);
        this.applyButton = new Button(this.myResources.getString("applyButtonLabel"));
        gridBagConstraints = this.makeConstraints(1, 4, 1, 1);
        gridBagConstraints.insets = new Insets(10, 10, 20, 20);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.gbl.setConstraints(this.applyButton, gridBagConstraints);
        this.applyButton.addActionListener(this);
        this.applyButton.setActionCommand(ApplyCommand);
        this.add(this.applyButton);
        this.cancelButton = new Button(this.myResources.getString("cancelButtonLabel"));
        gridBagConstraints = this.makeConstraints(2, 4, 1, 1);
        gridBagConstraints.insets = new Insets(10, 10, 20, 20);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.gbl.setConstraints(this.cancelButton, gridBagConstraints);
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand(CancelCommand);
        this.add(this.cancelButton);
        this.addWindowListener(new CloseWindowHandler());
        this.show();
        int n2 = 0;
        while (n2 < 6) {
            this.doLayout();
            ++n2;
        }
    }

    private ResourceBundle getMyResources() {
        return this.myResources;
    }

    private GridBagConstraints makeConstraints(int n, int n2, int n3, int n4) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        return gridBagConstraints;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ApplyCommand)) {
            if (this.wideBoxScheme.getState()) {
                this.jdmLayout.setScheme(0);
                this.jdmLayout.setFracts(((JdmLayout)this.widePanel.getLayout()).getFracts());
            } else if (this.tallBoxScheme.getState()) {
                this.jdmLayout.setScheme(1);
                this.jdmLayout.setFracts(((JdmLayout)this.tallPanel.getLayout()).getFracts());
            }
            this.browser.invalidate();
            this.browser.validate();
            return;
        }
        if (string.equals(CancelCommand)) {
            this.close();
            return;
        }
        System.out.println("BrowserApplet doesn't understand event:" + actionEvent);
    }

    public void close() {
        this.browser.layoutDialogEnded();
        ((Component)this).setVisible(false);
        this.dispose();
    }

    final /* synthetic */ ResourceBundle access$0() {
        return this.getMyResources();
    }

    class SampleLayout
    extends Container {
        public SampleLayout(int n) {
            JdmLayoutDialog.this = JdmLayoutDialog.this;
            this.setBackground(Color.blue);
            AxisCanvas axisCanvas = new AxisCanvas(Color.lightGray);
            AxisCanvas axisCanvas2 = new AxisCanvas(Color.lightGray);
            Label label = new Label(JdmLayoutDialog.this.access$0().getString("treeLabel"), 1);
            Label label2 = new Label(JdmLayoutDialog.this.access$0().getString("graphicLabel"), 1);
            Label label3 = new Label(JdmLayoutDialog.this.access$0().getString("detailsLabel"), 1);
            JdmLayout jdmLayout = new JdmLayout();
            jdmLayout.setScheme(n);
            this.setLayout(jdmLayout);
            this.add("NavTree", label);
            this.add("DeviceGraphic", label2);
            this.add("DestPanel", label3);
            this.add("Axis1", axisCanvas);
            this.add("Axis2", axisCanvas2);
            this.setSize(200, 100);
        }

        public void paint(Graphics graphics) {
            graphics.setColor(Color.blue);
            graphics.fillRect(0, 0, this.getBounds().x, this.getBounds().y);
            super.paint(graphics);
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMinimimumSize() {
            return new Dimension(100, 200);
        }
    }

    private class CloseWindowHandler
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            JdmLayoutDialog.this.close();
        }

        CloseWindowHandler() {
            JdmLayoutDialog.this = JdmLayoutDialog.this;
        }
    }
}

